/*
 * Decompiled with CFR 0.152.
 */
package jade;

import jade.core.ProfileException;
import jade.core.ProfileImpl;
import jade.core.Runtime;
import jade.util.Logger;
import jade.util.leap.Properties;
import java.util.Enumeration;

public class Boot {
    public static final String DEFAULT_FILENAME = "leap.properties";
    private static Logger logger = Logger.getMyLogger("jade.Boot");

    public static void main(String[] args) {
        block4: {
            try {
                ProfileImpl p = null;
                p = args.length > 0 ? (args[0].startsWith("-") ? new ProfileImpl(Boot.parseCmdLineArgs(args)) : new ProfileImpl(args[0])) : new ProfileImpl(DEFAULT_FILENAME);
                Runtime.instance().setCloseVM(true);
                if (p.getBooleanProperty("main", true)) {
                    Runtime.instance().createMainContainer(p);
                    break block4;
                }
                Runtime.instance().createAgentContainer(p);
            }
            catch (ProfileException pe) {
                System.err.println("Error creating the Profile [" + pe.getMessage() + "]");
                pe.printStackTrace();
                Boot.printUsage();
                System.exit(-1);
            }
            catch (IllegalArgumentException iae) {
                System.err.println("Command line arguments format error. " + iae.getMessage());
                iae.printStackTrace();
                Boot.printUsage();
                System.exit(-1);
            }
        }
    }

    public static Properties parseCmdLineArgs(String[] args) throws IllegalArgumentException {
        Properties props = new Properties();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equalsIgnoreCase("-container")) {
                    props.setProperty("main", "false");
                    continue;
                }
                if (args[i].equalsIgnoreCase("-backupmain")) {
                    props.setProperty("backupmain", "true");
                    continue;
                }
                if (args[i].equalsIgnoreCase("-gui")) {
                    props.setProperty("gui", "true");
                    continue;
                }
                if (args[i].equalsIgnoreCase("-name")) {
                    if (++i < args.length) {
                        props.setProperty("platform-id", args[i]);
                        continue;
                    }
                    throw new IllegalArgumentException("No platform name specified after \"-name\" option");
                }
                if (args[i].equalsIgnoreCase("-host")) {
                    if (++i < args.length) {
                        props.setProperty("host", args[i]);
                        continue;
                    }
                    throw new IllegalArgumentException("No host name specified after \"-host\" option");
                }
                if (args[i].equalsIgnoreCase("-port")) {
                    if (++i < args.length) {
                        props.setProperty("port", args[i]);
                        continue;
                    }
                    throw new IllegalArgumentException("No port number specified after \"-port\" option");
                }
                if (args[i].equalsIgnoreCase("-conf")) {
                    if (++i < args.length) {
                        try {
                            Properties pp = new Properties();
                            pp.load(args[i]);
                            Enumeration<Object> kk = pp.keys();
                            while (kk.hasMoreElements()) {
                                String key = (String)kk.nextElement();
                                if (props.containsKey(key)) continue;
                                props.setProperty(key, pp.getProperty(key));
                            }
                        }
                        catch (Exception e) {
                            if (!logger.isLoggable(Logger.SEVERE)) continue;
                            logger.log(Logger.SEVERE, "WARNING: error loading properties from file " + args[i] + ". " + e);
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("No configuration file name specified after \"-conf\" option");
                }
                if (args[i].equalsIgnoreCase("-mtp")) {
                    if (++i >= args.length) {
                        throw new IllegalArgumentException("No mtps specified after \"-mtp\" option");
                    }
                    props.setProperty("mtps", args[i]);
                    if (props.getProperty("nomtp") == null || !logger.isLoggable(Logger.WARNING)) continue;
                    logger.log(Logger.WARNING, "WARNING: both \"-mtp\" and \"-nomtp\" options specified. The latter will be ignored");
                    continue;
                }
                if (args[i].equalsIgnoreCase("-nomtp")) {
                    props.setProperty("nomtp", "true");
                    if (props.getProperty("mtps") == null || !logger.isLoggable(Logger.WARNING)) continue;
                    logger.log(Logger.WARNING, "WARNING: both \"-mtp\" and \"-nomtp\" options specified. The latter will be ignored");
                    continue;
                }
                if (args[i].equalsIgnoreCase("-agents")) {
                    if (++i < args.length) {
                        props.setProperty("agents", args[i]);
                        continue;
                    }
                    throw new IllegalArgumentException("No agents specified after \"-agents\" option");
                }
                String name = args[i].substring(1);
                if (++i < args.length) {
                    props.setProperty(name, args[i]);
                    continue;
                }
                throw new IllegalArgumentException("No value specified for property \"" + name + "\"");
            }
            if (props.getProperty("agents") != null && logger.isLoggable(Logger.WARNING)) {
                logger.log(Logger.WARNING, "WARNING: overriding agents specification set with the \"-agents\" option");
            }
            String agents = args[i];
            props.setProperty("agents", args[i]);
            if (++i >= args.length) break;
            if (logger.isLoggable(Logger.WARNING)) {
                logger.log(Logger.WARNING, "WARNING: ignoring command line argument " + args[i] + " occurring after agents specification");
            }
            if (agents != null && agents.indexOf(40) != -1 && !agents.endsWith(")") && logger.isLoggable(Logger.WARNING)) {
                logger.log(Logger.WARNING, "Note that agent arguments specifications must not contain spaces");
            }
            if (args[i].indexOf(58) == -1 || !logger.isLoggable(Logger.WARNING)) break;
            logger.log(Logger.WARNING, "Note that agent specifications must be separated by a semicolon character \";\" without spaces");
            break;
        }
        return props;
    }

    public static void printUsage() {
        System.out.println("Usage 1:");
        System.out.println("java -cp <classpath> jade.Boot <property-file-name>");
        System.out.println("\nUsage 2:");
        System.out.println("java -cp <classpath> jade.Boot [options] [agents]");
        System.out.println("Options:");
        System.out.println("    -container");
        System.out.println("    -gui");
        System.out.println("    -name <platform-name>");
        System.out.println("    -host <main-host>");
        System.out.println("    -port <main-port>");
        System.out.println("    -mtp <semicolon-separated mtp-specifiers>");
        System.out.println("     where mtp-specifier = [in-address:]<mtp-class>[(comma-separated args)]");
        System.out.println("    -nomtp");
        System.out.println("    -<property-name> <property-value>");
        System.out.println("Agents: [-agents] <semicolon-separated agent-specifiers>");
        System.out.println("     where agent-specifier = <agent-name>:<agent-class>[(comma separated args)]");
        System.out.println();
    }
}

